@echo off
echo NOTE: Make sure BSL-Scripter is installed and a DFU device is connected
echo before continuing! (http://www.ti.com/tool/MSPBSL)
echo.
pause
echo.


:: Change directory to parent folder of this batch file
::cd %~dp0
::cd..
echo The current folder is: "%CD%"
echo.


:: Path to script file (in current directory)
set script_name=scripts\bsl_app_script.txt
set script_path="%cd%\%script_name%"
echo Script file:
echo. %script_path%
echo.

:: Path to firmware binary file (in current directory)
::set hex_name=TMAG5273EVM_FW.txt
::set hex_path="%cd%\%hex_name%"
::echo Hex file:
::echo. %hex_path%
::echo.


:: Directory of the BSL-Scriptor executable
:: Download from http://software-dl.ti.com/msp430/msp430_public_sw/mcu/msp430/MSPBSL_Scripter/latest/index_FDS.html
::set bsl_folder="C:\ti\BSL-Scripter"

:: Change directory to BSL-Scriptor executable
::cd %bsl_folder%
echo BSL-Scriptor Directory:
echo. "%CD%"
echo.


:: Run BSL-Scriptor from the command line
:: "/b" sends output to the same command line window
:: "/w" waits for the program to complete

:: Calling tool from command line WITH a script file...
start /b /w BSL-Scripter.exe %script_path%

:: Calling tool from command line with NO SCRIPT file...
::start /b /w BSL-Scripter.exe --log -i [USB] --device E4xx --erase ERASE_SEGMENT --write %hex_path% --exit [RESET]


:: Wait for the user to press a key before closing the command window...
echo.
pause